<?xml version="1.0" encoding="iso-8859-1"?>

<!-- adaptation des chemins internes d'un doc html -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" >
	<xsl:output method="html" />
	<xsl:param name="path" />
	<xsl:param name="doc" />
	<xsl:template match="/">
  		<xsl:call-template name="update-path">
			<xsl:with-param name="currentnode" select="."/>
		</xsl:call-template>	
      </xsl:template>

	<!-- sous-template pour chercher les attributs à remplacer -->
	<xsl:template name="update-path" >
		<xsl:param name="currentnode"/>
		<xsl:for-each select="*">
			<xsl:variable name="subnode" select="."/>
			<xsl:choose>
				<xsl:when test="name()='img' or name()='frame'">
					<xsl:element name="{name()}">
					<xsl:for-each select="@*">
						<xsl:choose>
							<xsl:when test="name()='src'">
								<xsl:attribute name="{name()}">res-<xsl:value-of select="concat(concat(substring-after($path, '/'), '/'), .)"/></xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="{name()}">
									<xsl:value-of select="." />
								</xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:for-each>
					</xsl:element>
				</xsl:when>
				<xsl:when test="name()='link'">
					<xsl:element name="{name()}">
					<xsl:for-each select="@*">
						<xsl:choose>
							<xsl:when test="name()='href'">
								<xsl:attribute name="{name()}">res-<xsl:value-of select="concat(concat(substring-after($path, '/'), '/'), .)"/></xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="{name()}">
									<xsl:value-of select="." />
								</xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:for-each>
					</xsl:element>
				</xsl:when>
				<!-- liens interdocuments -->
				<xsl:when test="name()='a' or name()='A'">
					<xsl:element name="{name()}">
					<xsl:for-each select="@*">
						<xsl:choose>
							<xsl:when test="name()='href' and not(starts-with(., '/')) and not(starts-with(., 'http://'))">
								<xsl:attribute name="{name()}">.?path=<xsl:value-of select="substring-before($path, $doc)"/>&amp;doc=<xsl:value-of select="$doc"/>&amp;file=<xsl:value-of select="."/></xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="{name()}">
									<xsl:value-of select="." />
								</xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:for-each>
					<xsl:value-of select="text()"/>
					</xsl:element>
				</xsl:when>
				<!-- Cas des noeuds à fils -->
				<xsl:when test="name()='body' or name()='table'">
					<xsl:element name="{name()}">
					<xsl:for-each select="@*">
						<xsl:choose>
							<xsl:when test="name()='background'">
								<xsl:attribute name="{name()}">res-<xsl:value-of select="concat(concat(substring-after($path, '/'), '/'), .)"/></xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="{name()}">
									<xsl:value-of select="." />
								</xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:for-each>
					<xsl:call-template name="update-path">
							<xsl:with-param name="currentnode" select="$subnode"/>
					</xsl:call-template>
					</xsl:element>
				</xsl:when>
				<!-- le noeud a-t-il des fils ?-->
				<xsl:when test="*">
					<xsl:element name="{name($subnode)}">
						<xsl:for-each select="$subnode/@*">
							<xsl:attribute name="{name()}">
								<xsl:value-of select="." />
							</xsl:attribute>
						</xsl:for-each>
						<xsl:call-template name="update-path">
							<xsl:with-param name="currentnode" select="$subnode"/>
						</xsl:call-template>
					</xsl:element>
				</xsl:when>	
				<!-- si c'est une feuille on le recopie -->	
				<xsl:otherwise>
					<xsl:copy-of select="."/>
				</xsl:otherwise>	
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>	
</xsl:stylesheet>
  